# Assignment IDs
$assignmentAVD_ID  = "0001CoABChBS05JgaNcR8Llk9I7R61qcEigIACAAAgAJABVq8uLOMOURdUm1wsfHYiHgKxod2pZZWGy8SmaY09vPGkBrLgKqVJyCGXT5DuH05z_KeyGA28MWP1hvmY4XE2p6vm9kXqwpXQCtElDQcmPHtRP4mDmFbxA9lGU6Kpfw6wX9IAEQwK-0nAQ="
$assignmentHost_ID = "0001CoABChBrCl4gUsIR8LxkvC1jsnaoEigIACAAAgAJAFOvFm8WCOZgnmFbM0epWJN4ZBQxub7wP9K8bWKNW0WOGkAfgbNeyc24WRWZcR98jL4HpeoffrEMOcuODTu-Dhm_SefsLUpBI6oe-DWmnJ6eRtnhkD84xVOqy90fJlUIZpzAIAEQvebpvwU="
$assignmentFull_ID = "0001CoABChCfGkwQaLcR8IiH28ls_Sl2EigIACAAAgAJALJCXk4tkmMQS4nR7chWleHn8tGS9maxxAfbLVEaXa2TGkB_lBTbRx8riB9Ho5I01kYCNHEwq8ClLfSxropFveY7dWTXnrcdAOWOiSBhcGEqHTwQxasFJ3cAgrvBnH8_SLNdIAEQgLDIjQo="

$teamViewerExe = "C:\Program Files\TeamViewer\TeamViewer.exe"

try {
    $productName = ([System.Diagnostics.FileVersionInfo]::GetVersionInfo($teamViewerExe)).ProductName

    if ($productName -eq "TeamViewer Full") {
        $assignmentId = $assignmentFull_ID
    } elseif ($productName -eq "TeamViewer Host" -and $env:COMPUTERNAME -like "AVD*") {
        $assignmentId = $assignmentAVD_ID
    } else {
        $assignmentId = $assignmentHost_ID
    }
} catch {
    exit 1
}

Start-Process -FilePath $teamViewerExe -ArgumentList @(
    "assignment"
    "--id=$assignmentId"
    "--retries=3"
    "--timeout=120"
)
Start-Sleep -Seconds 15
if (-not (Get-Process -Name "TeamViewer" -ErrorAction SilentlyContinue)) {
    Start-Process -FilePath $teamViewerExe -WindowStyle Minimized
}

Write-Output "TeamViewer assignment launched."